#include "LCD1_Menu.h"
#include "UserEvent.h"
#include "MG32x02z_USBD_MGData.h"
#include "MG32x02z_LM35DZ_API.h"
//#include "MG32x02z_DS1621_API.h"

extern uint16_t API_DS1621_GetTemperature(void);

extern __IO uint8_t RxBuffer[160];
extern __IO uint8_t RxBufferCount;
extern MGData_TypeDef           MGData_CTR;
extern RTC_HandleTypeDef        mRTC;
extern Display_HandleTypeDef    LCD1st;
extern Display_HandleTypeDef    LCD2nd;
extern API_FlashHandlerTypeDef  API_Flash;
extern const unsigned char gLogo;
extern const unsigned char gBLE0;
extern const unsigned char gBLE1;
extern const unsigned char gBLE2;
extern const unsigned char gBLE3;
extern const unsigned char Home_Icon;
extern const unsigned char Back_Icon;
extern const unsigned char USB_Icon;
extern const unsigned char USB_Icon2;
extern const unsigned char WIFI_Icon;
extern const unsigned char Audio_Icon;
extern const unsigned char LightRGB_ICON;
extern const unsigned char Sttting;

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
__IO uint8_t gOldMenu = 0xFF;
__IO uint8_t gOldSelect = 6;
__IO static uint8_t gOldOption = 0;

__IO static uint8_t gOldSoundSelect = 1;
__IO static uint8_t gOldSoundPlayStop = 0;
__IO static uint8_t gOldSoundVolume = 1;

__IO static uint8_t gOldLCDPicture = 0;

__IO static uint8_t gOldLEDPWMSpeed = 0;
__IO static uint8_t gOldLEDBreathingSpeed = 0;
__IO static uint8_t gOldLEDBLinkingSpeed = 0;

__IO static uint8_t gOldSetIdleTime = 3;
__IO static uint8_t gOldSetBLE = 1;
__IO static uint8_t gOldSetWIFI = 0;
__IO static uint8_t gOldSetTempture = 0;
__IO static uint8_t gOldSetUpdate = 0;

__IO static uint8_t gOldRTCDate = 0;
__IO static uint8_t gOldRTCSeconds = 0;

__IO uint16_t gOldDS1621Temp = 0;
__IO uint16_t gOldLM35DZTemp = 0;

/* Private function prototypes -----------------------------------------------*/
void LCD_ColorBar_1(Display_HandleTypeDef *DispX);
void LCD_ColorBar_2(Display_HandleTypeDef *DispX);
void LCD_GrayBar_1(Display_HandleTypeDef *DispX);
void LCD_Random_Text(Display_HandleTypeDef *DispX);
void LCD_Random_Line(Display_HandleTypeDef *DispX);
void LCD_Random_Fill(Display_HandleTypeDef *DispX);
void LCD_Random_Rectangle(Display_HandleTypeDef *DispX);
void LCD_Random_Circle(Display_HandleTypeDef *DispX);
void LCD_Random_Geometry(Display_HandleTypeDef *DispX);

/* Exported functions --------------------------------------------------------*/

uint32_t const IdleTimeValue[] = {0, 3000, 5000, 
                                  10000, 15000, 20000, 25000, 30000, 
                                  60000, 120000, 180000, 300000,
                                  600000, 900000, 1200000, 1500000, 1800000,};
uint8_t const IdleTimeStr[][5] = {"  Dis", " 3Sec", " 5Sec", 
                                  "10Sec", "15Sec", "20Sec", "25Sec", "30Sec",
                                  " 1Min", " 2Min", " 3Min", " 5Min", 
                                  "10Min", "15Min", "20Min", "25Min", "30Min"};

uint8_t const Speed[][5] = {"  1ms", "  2ms", "  3ms", "  5ms",
                            " 10ms", " 20ms", " 30ms", " 50ms",
                            "100ms", "200ms", "300ms", "500ms",
                            "   1s", "   2s", "   3s", "   5s",
                            "  10s", "  15s", "  20s"}; //duty 50%

uint8_t const OnOffStr[][4] = {"OFF ", " ON ",};

uint8_t const EnDisStr[][4] = {" En ", "Dis ",};

extern UEvent_HandleTypedef gUEvent;
GUIMenu_HandleTypedef gUMenu;

void LCD_Show_Text(Display_HandleTypeDef *DispX)
{
  #if(MG0404)
    DispX->BackLight(0x0000);
  #endif
    LCD_Clear(DispX, BLACK);

    LCD_ShowString(DispX, 0, 0, DispX->Width, 24, GBLUE, 24, (uint8_t *)"Megawin Company");
    LCD_ShowString(DispX, 0, 24, DispX->Width, 24, BRED, 24, (uint8_t *)"ARM Cortex-M0 Series");
    LCD_ShowString(DispX, 0, 48, DispX->Width, 24, YELLOW, 24, (uint8_t *)"Product MG32F02U");
    LCD_ShowString(DispX, 0, 72, DispX->Width, 24, GREEN, 24, (uint8_t *)"Show Features");
    LCD_ShowString(DispX, 0, 96, DispX->Width, 24, BLUE, 24, (uint8_t *)"2021/01/12");

    LCD_ShowString(DispX, 0, 144, DispX->Width, 16, WHITE, 16, (uint8_t *)"Megawin Company");
    LCD_ShowString(DispX, 0, 160, DispX->Width, 16, WHITE, 16, (uint8_t *)"ARM Cortex-M0 Series");
    LCD_ShowString(DispX, 0, 176, DispX->Width, 16, WHITE, 16, (uint8_t *)"Product MG32F02U");
    LCD_ShowString(DispX, 0, 192, DispX->Width, 16, WHITE, 16, (uint8_t *)"Show Features");
    LCD_ShowString(DispX, 0, 208, DispX->Width, 16, WHITE, 16, (uint8_t *)"2021/01/12");

    LCD_ShowString(DispX, 0, 240, DispX->Width, 12, WHITE, 12, (uint8_t *)"Megawin Company");
    LCD_ShowString(DispX, 0, 252, DispX->Width, 12, WHITE, 12, (uint8_t *)"ARM Cortex-M0 Series");
    LCD_ShowString(DispX, 0, 264, DispX->Width, 12, WHITE, 12, (uint8_t *)"Product MG32F02U");
    LCD_ShowString(DispX, 0, 276, DispX->Width, 12, WHITE, 12, (uint8_t *)"Show Features");
    LCD_ShowString(DispX, 0, 288, DispX->Width, 12, WHITE, 12, (uint8_t *)"2021/01/12");

  #if(MG0404)
    DispX->BackLight(0xFFFF);
  #endif
}

/**
 *******************************************************************************
 * @brief       Random show string
 * @return      None
 *******************************************************************************
 */
 
void LCD_Random_Text(Display_HandleTypeDef *DispX)
{   uint16_t lCount = 50;
    LCD_Clear(DispX, BLACK);
    LCD_ShowString(DispX, 0, 80, DispX->Width, 24, 0x001F, 24, (uint8_t *)"Megawin Company");
    LCD_ShowString(DispX, 0, 104, DispX->Width, 24, 0x33E0, 24, (uint8_t *)"ARM Cortex-M0 Series");
    LCD_ShowString(DispX, 0, 128, DispX->Width, 24, 0xF100, 24, (uint8_t *)"Product MG32F02A");
    MID_Delay(1000);
    do{
        LCD_ShowString(DispX, rand() % DispX->Width, rand() % DispX->Height, DispX->Width, 24, rand() % 0xFFFF, 24, (uint8_t *)"Megawin Company");
        LCD_ShowString(DispX, rand() % DispX->Width, rand() % DispX->Height, DispX->Width, 24, rand() % 0xFFFF, 24, (uint8_t *)"ARM Cortex-M0 Series");
        LCD_ShowString(DispX, rand() % DispX->Width, rand() % DispX->Height, DispX->Width, 24, rand() % 0xFFFF, 24, (uint8_t *)"Product MG32F02A");
    }while(-- lCount != 0);
}

/**
 *******************************************************************************
 * @brief       Random show Line
 * @return      None
 *******************************************************************************
 */
void LCD_Random_Line(Display_HandleTypeDef *DispX)
{
    uint16_t lCount = 500;
    LCD_Clear(DispX, BLACK);
    do{

        LCD_DrawLine(DispX, rand() % DispX->Width, rand() % DispX->Height, rand() % DispX->Width, rand() % DispX->Height, rand() % 0xFFFF);
    }while(-- lCount != 0);
}

/**
 *******************************************************************************
 * @brief       Random show Rectangle
 * @return      None
 *******************************************************************************
 */
void LCD_Random_Rectangle(Display_HandleTypeDef *DispX)
{
    uint16_t lCount = 200;
    LCD_Clear(DispX, BLACK);
    do{
        LCD_DrawRectangle(DispX, rand() % DispX->Width, rand() % DispX->Height, rand() % DispX->Width, rand() % DispX->Height, rand() % 0xFFFF);
    }while(-- lCount != 0);
}

/**
 *******************************************************************************
 * @brief       Random show Circle
 * @return      None
 *******************************************************************************
 */
void LCD_Random_Circle(Display_HandleTypeDef *DispX)
{
    uint16_t lCount = 200;
    LCD_Clear(DispX, BLACK);
    do{
        LCD_Draw_Circle(DispX, rand() % DispX->Width, rand() % DispX->Height, rand() % DispX->Height, rand() % 0xFFFF);
    }while(-- lCount != 0);
}

/**
 *******************************************************************************
 * @brief       Random show Geometry
 * @return      None
 *******************************************************************************
 */
void LCD_Random_Geometry(Display_HandleTypeDef *DispX)
{
    uint16_t lCount = 100;
    LCD_Clear(DispX, BLACK);
    do{
        LCD_DrawLine(DispX, rand() % DispX->Width, rand() % DispX->Height, rand() % DispX->Width, rand() % DispX->Height, rand() % 0xFFFF);
        LCD_DrawRectangle(DispX, rand() % DispX->Width, rand() % DispX->Height, rand() % DispX->Width, rand() % DispX->Height, rand() % 0xFFFF);
        LCD_Draw_Circle(DispX, rand() % DispX->Width, rand() % DispX->Height, rand() % DispX->Height, rand() % 0xFFFF);
    }while(-- lCount != 0);
}

/**
 *******************************************************************************
 * @brief       Random show Random
 * @return      None
 *******************************************************************************
 */
void LCD_Random_Fill(Display_HandleTypeDef *DispX)
{
    uint16_t lCount = 100;
    LCD_Clear(DispX, BLACK);
    do{
        LCD_Fill(DispX, rand() % DispX->Width, rand() % DispX->Height, rand() % DispX->Width, rand() % DispX->Height, rand() % 0xFFFF);
    }while(-- lCount != 0);
}

void ShowPicture(Display_HandleTypeDef *DispX, uint16_t nTh)
{
    uint32_t lTemp32;

    lTemp32 = 0x25800 * nTh;

    if(DispX->Width < 240)
    {
        LCD_ShowStringX(DispX, 0, 0, DispX->Width, 14, RED, WHITE, 12, (uint8_t *)"Error");
        return;
    }
    LCD_Set_Window(&LCD1st, ((DispX->Width / 2) - 120), ((DispX->Height / 2) - 160), 240, 320);
    LCD_SetCursor(DispX, ((DispX->Width / 2) - 120), ((DispX->Height / 2) - 160));
    DispX->SelectReg(DispX->GRAMcmd);

    if(DispX->WriteRegister == &I80_LCD_WriteRegister)
    {
        __LCD_RS_SET();
        __LCD_CS_CLR();

        // Get flash 0x00001000 data, confirm erase success
        API_Flash_MultiBytesRead(lTemp32, (uint8_t *)0x60000000, 0x1FFFE);
        lTemp32 += 0x1FFFE;
        while(API_Flash.State != API_FLASH_STATE_READY);

        API_Flash_MultiBytesRead(lTemp32, (uint8_t *)0x60000000, 0x5802);
        while(API_Flash.State != API_FLASH_STATE_READY);
        __LCD_CS_SET();
    }
    LCD_ShowStringX(DispX, (((DispX->Width / 2) + 120) - 45), (((DispX->Height / 2) + 160) - 14), (((DispX->Width / 2) + 120) - 1), (((DispX->Height / 2) + 160) - 1), RED, WHITE, 12, (uint8_t *)"Picture");
    LCD_Set_Window(DispX, 0, 0, DispX->Width, DispX->Height);
}

void MenuFrame(GUIMenu_HandleTypedef *UMenu)
{
    if((UMenu->Frame & 0x00000080UL) != 0)
        LCD_Fill(&LCD1st, 0, 50, 239, 319, BLACK);

//    if(((UMenu->Frame & 0x00000040UL) != 0) && ((UMenu->Frame & 0x00000080UL) == 0))
//        LCD_Fill(&LCD1st, 0, 53, 50, 103, BLACK);
    if((UMenu->Frame & 0x00004000UL) != 0)
        LCD_ButtonUp(&LCD1st, 0, 53, 50, 103, GRAY);           // Home or Setting
    if((UMenu->Frame & 0x00400000UL) != 0)
        LCD_ButtonUp(&LCD1st, 0, 53, 50, 103, WHITE);            // Home or Setting
    if((UMenu->Frame & 0x40000000UL) != 0)
        LCD_ButtonUp(&LCD1st, 0, 53, 50, 103, RED);             // Home or Setting

//    if(((UMenu->Frame & 0x00000020UL) != 0) && ((UMenu->Frame & 0x00000080UL) == 0))
//        LCD_Fill(&LCD1st, 0, 107, 50, 319, BLACK);
    if((UMenu->Frame & 0x00002000UL) != 0)
        LCD_ButtonUp(&LCD1st, 0, 107, 50, 319, GRAY);          // Back and Return or Demo 
    if((UMenu->Frame & 0x00200000UL) != 0)
        LCD_ButtonUp(&LCD1st, 0, 107, 50, 319, WHITE);           // Back and Return or Demo 
    if((UMenu->Frame & 0x20000000UL) != 0)
        LCD_ButtonUp(&LCD1st, 0, 107, 50, 319, RED);            // Back and Return or Demo 

//    if(((UMenu->Frame & 0x00000001UL) != 0) && ((UMenu->Frame & 0x00000080UL) == 0))
//        LCD_Fill(&LCD1st, 54, 53, 239, 103, BLACK);
    if((UMenu->Frame & 0x00000100UL) != 0)
        LCD_ButtonUp(&LCD1st, 54, 53, 239, 103, GRAY);              // 1
    if((UMenu->Frame & 0x00010000UL) != 0)
        LCD_ButtonUp(&LCD1st, 54, 53, 239, 103, WHITE);             // 1
    if((UMenu->Frame & 0x01000000UL) != 0)
        LCD_ButtonUp(&LCD1st, 54, 53, 239, 103, RED);               // 1

//    if(((UMenu->Frame & 0x00000002UL) != 0) && ((UMenu->Frame & 0x00000080UL) == 0))
//        LCD_Fill(&LCD1st, 54, 107, 239, 157, BLACK);
    if((UMenu->Frame & 0x00000200UL) != 0)
        LCD_ButtonUp(&LCD1st, 54, 107, 239, 157, GRAY);             // 2
    if((UMenu->Frame & 0x00020000UL) != 0)
        LCD_ButtonUp(&LCD1st, 54, 107, 239, 157, WHITE);            // 2
    if((UMenu->Frame & 0x02000000UL) != 0)
        LCD_ButtonUp(&LCD1st, 54, 107, 239, 157, RED);              // 2

    if(gUEvent.Menu == 5)
    {
        if((UMenu->Frame & 0x00000400UL) != 0)
            LCD_ButtonUp(&LCD1st, 54, 185, 239, 319, GRAY);         // 3
        if((UMenu->Frame & 0x00040000UL) != 0)
            LCD_ButtonUp(&LCD1st, 54, 185, 239, 319, WHITE);        // 3
        if((UMenu->Frame & 0x04000000UL) != 0)
            LCD_ButtonUp(&LCD1st, 54, 185, 239, 319, RED);          // 3
    }
    else
    {
//        if(((UMenu->Frame & 0x00000004UL) != 0) && ((UMenu->Frame & 0x00000080UL) == 0))
//            LCD_Fill(&LCD1st, 54, 161, 239, 211, BLACK);
        if((UMenu->Frame & 0x00000400UL) != 0)
            LCD_ButtonUp(&LCD1st, 54, 161, 239, 211, GRAY);         // 3
        if((UMenu->Frame & 0x00040000UL) != 0)
            LCD_ButtonUp(&LCD1st, 54, 161, 239, 211, WHITE);        // 3
        if((UMenu->Frame & 0x04000000UL) != 0)
            LCD_ButtonUp(&LCD1st, 54, 161, 239, 211, RED);          // 3
    }

//    if(((UMenu->Frame & 0x00000008UL) != 0) && ((UMenu->Frame & 0x00000080UL) == 0))
//        LCD_Fill(&LCD1st, 54, 215, 239, 265, BLACK);
    if((UMenu->Frame & 0x00000800UL) != 0)
        LCD_ButtonUp(&LCD1st, 54, 215, 239, 265, GRAY);         // 4
    if((UMenu->Frame & 0x00080000UL) != 0)
        LCD_ButtonUp(&LCD1st, 54, 215, 239, 265, WHITE);          // 4
    if((UMenu->Frame & 0x08000000UL) != 0)
        LCD_ButtonUp(&LCD1st, 54, 215, 239, 265, RED);        // 4

//    if(((UMenu->Frame & 0x00000010UL) != 0) && ((UMenu->Frame & 0x00000080UL) == 0))
//        LCD_Fill(&LCD1st, 54, 269, 239, 319, BLACK);
    if((UMenu->Frame & 0x00001000UL) != 0)
        LCD_ButtonUp(&LCD1st, 54, 269, 239, 319, GRAY);         // 5
    if((UMenu->Frame & 0x00100000UL) != 0)
        LCD_ButtonUp(&LCD1st, 54, 269, 239, 319, WHITE);          // 5
    if((UMenu->Frame & 0x10000000UL) != 0)
        LCD_ButtonUp(&LCD1st, 54, 269, 239, 319, RED);        // 5
}

void Main_Menu(GUIMenu_HandleTypedef *Menu, UEvent_HandleTypedef *UEvent)
{
    Menu->Frame &= 0x474747C7UL;
    MenuFrame(Menu);

    LCD_ShowStringX(&LCD1st,  62,  65, 232, 24, WHITE, BLACK, 24, (uint8_t *)"RGB LED       ");
    LCD_ShowStringX(&LCD1st,  62, 119, 232, 24, WHITE, BLACK, 24, (uint8_t *)"LCD Display   ");
    LCD_ShowStringX(&LCD1st,  62, 173, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Sound         ");
    // LCD_ShowStringX(&LCD1st,  62, 227, 232, 24, WHITE, BLACK, 24, (uint8_t *)"ARGB          ");
    // LCD_ShowStringX(&LCD1st,  62, 280, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Communication ");
    // LCD_ShowStringX(&LCD1st,  10, 203, 232, 24, WHITE, BLACK, 16, (uint8_t *)"Demo");
    LCD_ShowStringX(&LCD1st,   8,  65, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Set");
}

void RGB_Menu(GUIMenu_HandleTypedef *Menu, UEvent_HandleTypedef *UEvent)
{
    __IO uint8_t  lArrayU8[80];

    Menu->Frame &= 0x2F2F2FAFL;
    MenuFrame(Menu);

    if((Menu->Frame & 0x00000081) != 0)
    {
        sprintf((char *)lArrayU8,"Spectrum");
        LCD_ShowStringX(&LCD1st, 62,  65, 232, 24,WHITE, BLACK, 24, ((uint8_t *)(&lArrayU8)));
    }

    if((Menu->Frame & 0x00000082) != 0)
    {
        sprintf((char *)lArrayU8,"Breathing");
        LCD_ShowStringX(&LCD1st, 62, 119, 232, 24, WHITE, BLACK, 24, ((uint8_t *)(&lArrayU8)));
    }

    if((Menu->Frame & 0x00000084) != 0)
    {
        sprintf((char *)lArrayU8,"Blinking");
        LCD_ShowStringX(&LCD1st, 62, 173, 232, 24, WHITE, BLACK, 24, ((uint8_t *)(&lArrayU8)));
    }

    if((Menu->Frame & 0x00000088) != 0)
    {
        LCD_ShowStringX(&LCD1st, 62, 227, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Stop          ");
    }

    if((Menu->Frame & 0x00000090) != 0)
    {
    }

    if((Menu->Frame & 0x000000A0) != 0)
    {
        LCD_ShowStringX(&LCD1st, 10, 203, 232, 24, WHITE, BLACK, 16, (uint8_t *)"Back");
    }

    if((Menu->Frame & 0x000000C0) != 0)
    {
        // LCD_ShowStringX(&LCD1st,   8, 65, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Home");
    }
}

void LCD_Menu(GUIMenu_HandleTypedef *Menu, UEvent_HandleTypedef *UEvent)
{
    Menu->Frame &= 0x2F2F2FD0UL;
    MenuFrame(Menu);

    LCD_ShowStringX(&LCD1st,  62,  65, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Feature");
    LCD_ShowStringX(&LCD1st,  62, 119, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Geometic");
    LCD_ShowStringX(&LCD1st,  62, 173, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Font");
    LCD_ShowStringX(&LCD1st,  62, 227, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Logo");
    // LCD_ShowStringX(&LCD1st,  62, 280, 232, 24, WHITE, BLACK, 24, (uint8_t *)"");
    LCD_ShowStringX(&LCD1st,  10, 203, 232, 24, WHITE, BLACK, 16, (uint8_t *)"Back");
    // LCD_ShowStringX(&LCD1st,   8,  65, 232,  24, WHITE, 24, (uint8_t *)"Set");
}

void Sound_Menu(GUIMenu_HandleTypedef *Menu, UEvent_HandleTypedef *UEvent)
{
    __IO uint8_t  lArrayU8[80];

    Menu->Frame &= 0x2F2F2FAFUL;
    MenuFrame(Menu);

    if((Menu->Frame & 0x00000081) != 0)
    {
        LCD_ShowStringX(&LCD1st,  62,  65, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Music");
        sprintf((char *)lArrayU8,"%2d",UEvent->SoundSelect);
        LCD_ShowStringX(&LCD1st, 209, 65, 232, 24, WHITE, BLACK, 24, ((uint8_t *)(&lArrayU8)));
    }

    LCD_ShowStringX(&LCD1st,  62, 119, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Play");

    LCD_ShowStringX(&LCD1st,  62, 173, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Stop");

    if((Menu->Frame & 0x00000088) != 0)
    {
        LCD_ShowStringX(&LCD1st,  62, 227, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Volume");
        sprintf((char *)lArrayU8, "%2d",UEvent->SoundVolume);
        LCD_ShowStringX(&LCD1st, 209, 227, 232, 24, WHITE, BLACK, 24, ((uint8_t *)(&lArrayU8)));
    }

    LCD_ShowStringX(&LCD1st,  10, 203, 232, 24, WHITE, BLACK, 16, (uint8_t *)"Back");
}

//void LCD_Menu(GUIMenu_HandleTypedef *Menu, UEvent_HandleTypedef *UEvent)
//{
//    Menu->Frame &= 0x3F3F3FC0UL;
//    MenuFrame(Menu);

//    LCD_ShowStringX(&LCD1st,  62,  65, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Pattern 1");
//    LCD_ShowStringX(&LCD1st,  62, 119, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Pattern 2");
//    LCD_ShowStringX(&LCD1st,  62, 173, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Pattern 3");
//    LCD_ShowStringX(&LCD1st,  62, 227, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Pattern 4");
//    LCD_ShowStringX(&LCD1st,  62, 280, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Pattern 5");
//    LCD_ShowStringX(&LCD1st,  10, 203, 232, 24, WHITE, BLACK, 16, (uint8_t *)"Back");
//    // LCD_ShowString(&LCD1st,  8, 65, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Set");
//}

//void menu500(GUIMenu_HandleTypedef *Menu, UEvent_HandleTypedef *UEvent)
//{
//    Menu->Frame &= 0x272727A7UL;
//    MenuFrame(Menu);

//    LCD_ShowStringX(&LCD1st,  62,  65, 232, 24, WHITE, BLACK, 24, (uint8_t *)"USB Multimedia");
//    LCD_ShowStringX(&LCD1st,  62, 119, 232, 24, WHITE, BLACK, 24, (uint8_t *)"BLE UART Tx");

//    LCD_ShowStringX(&LCD1st,  58, 161, 232, 24, WHITE, BLACK, 24, (uint8_t *)"BLE UART Rx");

//    if(RxBufferCount == 0)
//        LCD_ShowStringX(&LCD1st,  59, 189, 175, 125, WHITE, BLACK, 16, (uint8_t *)"Rx Buffer Empty");
//    else
//        LCD_ShowStringX(&LCD1st,  59, 189, 175, 125, WHITE, BLACK, 16, (uint8_t *)RxBuffer);

//    // LCD_ShowStringX(&LCD1st,  62, 173, 232, 24, WHITE, BLACK, 24, (uint8_t *)"");
//    // LCD_ShowStringX(&LCD1st,  62, 227, 232, 24, WHITE, BLACK, 24, (uint8_t *)"");
//    // LCD_ShowStringX(&LCD1st,  62, 280, 232, 24, WHITE, BLACK, 24, (uint8_t *)"");
//    LCD_ShowStringX(&LCD1st,  10, 203, 232, 24, WHITE, BLACK, 16, (uint8_t *)"Back");
//    // LCD_ShowStringX(&LCD1st,  08,  65, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Set");
//}

void Setting_Menu(GUIMenu_HandleTypedef *Menu, UEvent_HandleTypedef *UEvent)
{
    __IO uint8_t  lArrayU8[80];

    Menu->Frame &= 0x272727A7UL;
    MenuFrame(Menu);

    if((Menu->Frame & 0x00000081) != 0)
    {
        sprintf((char *)lArrayU8, "IdleTime %.5s",IdleTimeStr[UEvent->SetIdleTime]);
        LCD_ShowStringX(&LCD1st, 62, 65, 232, 24, WHITE, BLACK, 24, ((uint8_t *)(&lArrayU8)));
    }

    if((Menu->Frame & 0x00000082) != 0)
    {
        LCD_ShowStringX(&LCD1st, 62, 119, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Thermal  ");
        if(gUEvent.SetTempture == 0)
            LCD_ShowStringX(&LCD1st, 162, 119, 232, 24, GBLUE, BLACK, 24, (uint8_t *)"DS1621");
        else
            LCD_ShowStringX(&LCD1st, 162, 119, 232, 24, GBLUE, BLACK, 24, (uint8_t *)"LM35DZ");
    }

    if((Menu->Frame & 0x00000084) != 0)
    {
        LCD_ShowStringX(&LCD1st,  62, 173, 232, 24, WHITE, BLACK, 24, (uint8_t *)"Sync PC Time");
        // LCD_ShowStringX(&LCD1st, 136, 181, 232, 24, WHITE, BLACK, 16, (uint8_t *)"(DFU)");
    }

    //if((Menu->Frame & 0x00000088) != 0)
    //{
    //    sprintf((char *)lArrayU8, "BLE        %.3s",OnOffStr[UEvent->SetBLE]);
    //    LCD_ShowStringX(&LCD1st, 62, 119, 232, 24, WHITE, BLACK, 24, ((uint8_t *)(&lArrayU8)));
    //}

    //if((MENU->Frame & 0x00000090) != 0)
    //{
    //    LCD_ShowStringX(&LCD1st,  62, 280, 232, 24, WHITE, BLACK, 24, (uint8_t *)"");
    //}

    if((Menu->Frame & 0x000000A0) != 0)
    {
        LCD_ShowStringX(&LCD1st,  10, 203, 232, 24, WHITE, BLACK, 16, (uint8_t *)"Back");
    }

    //if((MENU->Frame & 0x000000C0) != 0)
    //{
    //    //LCD_ShowStringX(&LCD1st,   8,  65, 232, 24, WHITE, BLACK, 24, (uint8_t *)"");
    //}
}

void Auto_Menu(void)
{
    ShowPicture(&LCD1st, 0);
    MID_Delay(2000);

    ShowPicture(&LCD1st, 1);
    MID_Delay(2000);

    ShowPicture(&LCD1st, 2);
    MID_Delay(2000);

    ShowPicture(&LCD1st, 3);
    MID_Delay(2000);

    ShowPicture(&LCD1st, 4);
    MID_Delay(2000);

    ShowPicture(&LCD1st, 5);
    MID_Delay(2000);

    ShowPicture(&LCD1st, 6);
    MID_Delay(2000);

    ShowPicture(&LCD1st, 7);
    MID_Delay(2000);

    ShowPicture(&LCD1st, 8);
    MID_Delay(2000);

    LCD_Show_Text(&LCD1st);
    LCD_Show_Text(&LCD2nd);
    MID_Delay(3000); // Delay 1Sec

    LCD_GrayBar_1(&LCD1st);
    LCD_GrayBar_1(&LCD2nd);
    MID_Delay(3000); // Delay 1Sec

    LCD_ColorBar_1(&LCD1st);
    LCD_ColorBar_1(&LCD2nd);
    MID_Delay(3000); // Delay 1Sec

    LCD_ColorBar_2(&LCD1st);
    LCD_ColorBar_2(&LCD2nd);
    MID_Delay(3000); // Delay 1Sec

    LCD_Random_Line(&LCD1st);
    LCD_Random_Line(&LCD2nd);
    MID_Delay(1000); // Delay 1Sec

    LCD_Random_Rectangle(&LCD1st);
    LCD_Random_Rectangle(&LCD2nd);
    MID_Delay(1000); // Delay 1Sec

    LCD_Random_Circle(&LCD1st);
    LCD_Random_Circle(&LCD2nd);
    MID_Delay(1000); // Delay 1Sec

    LCD_Random_Geometry(&LCD1st);
    LCD_Random_Geometry(&LCD2nd);
    MID_Delay(1000); // Delay 1Sec

    LCD_Random_Text(&LCD1st);
    LCD_Random_Text(&LCD2nd);
    MID_Delay(1000); // Delay 1Sec

    LCD_Clear(&LCD1st, BLACK);
    ShowPicture(&LCD1st, 9);
    MID_Delay(2000);
}

void GUIMenu(GUIMenu_HandleTypedef *UMenu, UEvent_HandleTypedef *UEvent)
{
    __IO uint8_t  lArrayU8[80];
    __IO uint16_t lDS1621Temperature;
    __IO uint16_t lLM35DZTemperature;

//    Auto_Menu();
    if((gOldLCDPicture != 0) && (UEvent->LCDPicture == 0))
    {
        LCD_Fill(&LCD1st, 0, 0, 239, 319, BLACK);
        gOldLCDPicture = UEvent->LCDPicture;
        gOldMenu = 0;
        gOldOption = 0;
        gOldRTCDate = 0;
        gOldRTCSeconds = 0;
        gOldDS1621Temp = 0;
        gOldLM35DZTemp = 0;
    }

    if(MGData_CTR.AP_Connect != 0)
        LCD_Color_Fill(&LCD1st, 4, 4, 27, 42, (uint16_t*)&USB_Icon);
    else
        LCD_Fill(&LCD1st, 4, 4, 27, 42, BLACK);

    // LCD_Color_Fill(&LCD1st, 35, 7, 31, 40, (uint16_t*)&gBLE0);
    // LCD_Color_Fill(&LCD1st, 35, 7, 31, 40, (uint16_t*)&gBLE1);
    // LCD_Color_Fill(&LCD1st, 35, 7, 31, 40, (uint16_t*)&gBLE2);
    // LCD_Color_Fill(&LCD1st, 35, 7, 31, 40, (uint16_t*)&gBLE3);
    // LCD_Color_Fill(&LCD1st, 70, 10, 42, 34, (uint16_t*)&WIFI_Icon);

    if(UEvent->SetTempture == 0)
    {
        lDS1621Temperature = API_DS1621_GetTemperature();
        if(lLM35DZTemperature != gOldDS1621Temp)
        {
            if ((lDS1621Temperature & 0x00FF) == 0)
                sprintf((char *)lArrayU8, "%d.0C",lDS1621Temperature >> 8);
            else
                sprintf((char *)lArrayU8, "%d.5C",lDS1621Temperature >> 8);
            LCD_ShowStringX(&LCD1st, 50, 2, 60, 24, GBLUE, BLACK, 24, ((uint8_t *)(&lArrayU8)));
        }
    }
    else
    {                        
        lLM35DZTemperature = API_LM35DZ_GetTemperature();
        if(lLM35DZTemperature != gOldLM35DZTemp)
        {
            sprintf((char *)lArrayU8, "  %dC  ",lLM35DZTemperature);
            LCD_ShowStringX(&LCD1st, 50, 2, 60, 24, GBLUE, BLACK, 24, ((uint8_t *)(&lArrayU8)));
        }
    }

    MID_RTC_GetTime(&mRTC);
    if(gOldRTCDate != mRTC.sDate.Date)
    {
        sprintf((char *)lArrayU8, "%.4d/%.2d/%.2d", mRTC.sDate.Year, mRTC.sDate.Month, mRTC.sDate.Date);
        LCD_ShowStringX(&LCD1st, 118, 2, 109, 25, WHITE, BLACK, 24, (uint8_t *)lArrayU8);
        LCD_ShowStringX(&LCD2nd, 118, 2, 109, 25, WHITE, BLACK, 24, (uint8_t *)lArrayU8);
        gOldRTCDate = mRTC.sDate.Date;
    }

    if(gOldRTCSeconds != mRTC.sTime.Seconds)
    {
        sprintf((char *)lArrayU8, "%.2d:%.2d:%.2d", mRTC.sTime.Hours, mRTC.sTime.Minutes, mRTC.sTime.Seconds);
        if(mRTC.sTime.TimeFormat == 0)
            sprintf((char *)lArrayU8 + 8, "AM");
        else
            sprintf((char *)lArrayU8 + 8, "PM");

        LCD_ShowStringX(&LCD1st, 118, 26, 109, 25, WHITE, BLACK, 24, (uint8_t *)lArrayU8);
        LCD_ShowStringX(&LCD2nd, 118, 26, 109, 25, WHITE, BLACK, 24, (uint8_t *)lArrayU8);
        gOldRTCSeconds = mRTC.sTime.Seconds;
    }

//=============================================================================
    if(UEvent->Menu != gOldMenu)
    {
        UMenu->Frame = 0x00003F80UL;
        gOldSelect = 0;
        gOldOption = 0;
        switch(UEvent->Menu){
            case MainMenu:
                switch(gOldMenu){
                    case RGBMenu:
                        UMenu->Frame |= 0x00017E80UL;
                        break;
                    case LCDMenu:
                        UMenu->Frame |= 0x00047E80UL;
                        break;
                    case SoundMenu:
                        UMenu->Frame |= 0x00087E80UL;
                        break;
                    case SettingMenu:
                        UMenu->Frame |= 0x00407E80UL;
                        break;
                    default: 
                        UMenu->Frame |= 0x00207E80UL;
                        break;
                }
                Main_Menu(UMenu, UEvent);
                break;
            case RGBMenu:
                UMenu->Frame |= 0x00012E80UL;
                RGB_Menu(UMenu, UEvent);
                break;
            case LCDMenu:
                UMenu->Frame |= 0x00013E80UL;
                LCD_Menu(UMenu, UEvent);
                break;
            case SoundMenu:
                UMenu->Frame |= 0x00013E80UL;
                Sound_Menu(UMenu, UEvent);
                break;
            case SettingMenu:
                UMenu->Frame |= 0x00012680UL;
                Setting_Menu(UMenu, UEvent);
                break;
            default:
                break;
        }
        gOldMenu = UEvent->Menu;
    }

    if(UEvent->Select != gOldSelect)
    {
        UMenu->Frame = 0x00000000UL;
        switch(gOldSelect){
            case 1:
                UMenu->Frame |= 0x00000100UL;
                break;
            case 2:
                UMenu->Frame |= 0x00000200UL;
                break;
            case 3:
                UMenu->Frame |= 0x00000400UL;
                break;
            case 4:
                switch(UEvent->Menu){
                   case MainMenu:
                       UMenu->Frame |= 0x00004000UL;
                       break;
                   case SettingMenu:
                       UMenu->Frame |= 0x00002000UL;
                       break;
                   default:
                       UMenu->Frame |= 0x00000800UL;
                       break;
                }
                break;
            case 5:
                switch(UEvent->Menu){
                    case RGBMenu:
                    case LCDMenu:
                    case SoundMenu:
                        UMenu->Frame |= 0x00002000UL;
                        break;
                    default:
                        UMenu->Frame |= 0x00001000UL;
                        break;
                }
                break;
            default:
                UMenu->Frame |= 0x00007F00UL;
                break;
        }

        switch(UEvent->Select){
            case 1:
                UMenu->Frame |= 0x00010000UL;
                break;
            case 2:
                UMenu->Frame |= 0x00020000UL;
                break;
            case 3:
                UMenu->Frame |= 0x00040000UL;
                break;
            case 4:
                switch(UEvent->Menu){
                   case MainMenu:
                       UMenu->Frame |= 0x00400000UL;
                       break;
                   case SettingMenu:
                       UMenu->Frame |= 0x00200000UL;
                       break;
                   default:
                       UMenu->Frame |= 0x00080000UL;
                       break;
                }
                break;
            case 5:
                switch(UEvent->Menu){
                    case RGBMenu:
                    case LCDMenu:
                    case SoundMenu:
                        UMenu->Frame |= 0x00200000UL;
                        break;
                    default:
                        UMenu->Frame |= 0x00100000UL;
                        break;
                }
                break;
            default:
                UMenu->Frame |= 0x00000000UL;
                break;
        }

        switch(UEvent->Menu){
            case MainMenu:
                Main_Menu(UMenu, UEvent);
                break;
            case RGBMenu:
                RGB_Menu(UMenu, UEvent);
                break;
            case LCDMenu:
                LCD_Menu(UMenu, UEvent);
                break;
            case SoundMenu:
                Sound_Menu(UMenu, UEvent);
                break;
            case SettingMenu:
                Setting_Menu(UMenu, UEvent);
                break;
            default:
                break;
        }
        gOldSelect = UEvent->Select;
    }

    if(UEvent->Option != gOldOption)
    {
        if(UEvent->Option == UEvent->Select)
        {
            gOldOption = UEvent->Option;
        }

        UMenu->Frame = 0x00000000UL;
        switch(gOldOption){
            case 1:
                UMenu->Frame |= 0x00010000UL;
                break;
            case 2:
                UMenu->Frame |= 0x00020000UL;
                break;
            case 3:
                UMenu->Frame |= 0x00040000UL;
                break;
            case 4:
                UMenu->Frame |= 0x00080000UL;
                break;
            case 5:
                UMenu->Frame |= 0x00100000UL;
                break;
            case 6:
                UMenu->Frame |= 0x00200000UL;
                break;
            case 7:
                UMenu->Frame |= 0x00400000UL;
                break;
            default:
                UMenu->Frame |= 0x00000000UL;
                break;
        }

        switch(UEvent->Option){
            case 1:
                UMenu->Frame |= 0x01000000UL;
                break;
            case 2:
                UMenu->Frame |= 0x02000000UL;
                break;
            case 3:
                UMenu->Frame |= 0x04000000UL;
                break;
            case 4:
                UMenu->Frame |= 0x08000000UL;
                break;
            case 5:
                UMenu->Frame |= 0x10000000UL;
                break;
            case 6:
                UMenu->Frame |= 0x20000000UL;
                break;
            case 7:
                UMenu->Frame |= 0x40000000UL;
                break;
            default:
                UMenu->Frame |= 0x00000000UL;
                break;
        }
        gOldOption = UEvent->Option;
        switch(UEvent->Menu){
            case MainMenu:
                Main_Menu(UMenu, UEvent);
                break;
            case RGBMenu:
                RGB_Menu(UMenu, UEvent);
                break;
            case LCDMenu:
                LCD_Menu(UMenu, UEvent);
                break;
            case SoundMenu:
                Sound_Menu(UMenu, UEvent);
                break;
            case SettingMenu:
                Setting_Menu(UMenu, UEvent);
                break;
            default:
                break;
        }
    }

    if(gOldLEDPWMSpeed != UEvent->LEDPWMSpeed)
    {
        UMenu->Frame |= 0x01000001UL;
        gOldLEDPWMSpeed = UEvent->LEDPWMSpeed;
        RGB_Menu(UMenu, UEvent);
    }

    if(gOldLEDBreathingSpeed != UEvent->LEDBreathingSpeed)
    {
        UMenu->Frame |= 0x02000002UL;
        gOldLEDBreathingSpeed = UEvent->LEDBreathingSpeed;
        RGB_Menu(UMenu, UEvent);
    }

    if(gOldLEDBLinkingSpeed != UEvent->LEDBLinkingSpeed)
    {
        UMenu->Frame |= 0x04000004UL;
        gOldLEDBLinkingSpeed = UEvent->LEDBLinkingSpeed;
        RGB_Menu(UMenu, UEvent);
    }

    if(gOldSoundSelect != UEvent->SoundSelect)
    {
        UMenu->Frame |= 0x01000001UL;
        gOldSoundSelect = UEvent->SoundSelect;
        Sound_Menu(UMenu, UEvent);
    }

    if(gOldSoundVolume != UEvent->SoundVolume)
    {
        UMenu->Frame |= 0x08000008UL;
        gOldSoundVolume = UEvent->SoundVolume;
        Sound_Menu(UMenu, UEvent);
    }

    if(gOldSetIdleTime != UEvent->SetIdleTime)
    {
        UMenu->Frame |= 0x01000001UL;
        gOldSetIdleTime = UEvent->SetIdleTime;
        Setting_Menu(UMenu, UEvent);
    }

    if(gOldSetTempture != UEvent->SetTempture)
    {
        UMenu->Frame |= 0x02000002UL;
        gOldSetTempture = UEvent->SetTempture;
        Setting_Menu(UMenu, UEvent);
    }
}

void LCD_1st_Show(void)
{
    if(gUEvent.LCDPicture == 0) 
        GUIMenu(&gUMenu, &gUEvent);
    else
    {
        if(gOldLCDPicture != gUEvent.LCDPicture)
        {
            gOldLCDPicture = gUEvent.LCDPicture;
            switch(gUEvent.LCDPicture){
                case 0:
                    break;

                case 247:
                    LCD_GrayBar_1(&LCD1st);
                    break;

                case 248:
                    LCD_ColorBar_1(&LCD1st);
                    break;

                case 249:
                    LCD_ColorBar_2(&LCD1st);
                    break;

                case 250:
                    LCD_Random_Geometry(&LCD1st);
                    break;

                case 251:
                    LCD_Random_Line(&LCD1st);
                    break;

                case 252:
                    LCD_Random_Rectangle(&LCD1st);
                    break;

                case 253:
                    LCD_Random_Circle(&LCD1st);
                    break;

                case 254:
                    LCD_Show_Text(&LCD1st);
                    break;

                case 255:
                    LCD_Random_Text(&LCD1st);
                    break;

                default:
                    ShowPicture(&LCD1st, (gUEvent.LCDPicture - 1));
                    break;
            }
        }
    }
}


